/** **********************************************************************
 * Random 8 x 8 test matrix - used in development to compare to MATLAB
 * GMRES
 *
 * @brief
 * GMRES vs. MATLAB
 * b = A*ones(8,1)                  
 * gmres(A,B,RESTART,TOL,MAXIT,M)
 * x = gmres(A,b,10,tol,maxit,M);
 * 
 * Solution: x = [1,1,1,1, ... 1]' with relative residual 1.1e-13.
 * 
 * @author:     James Quinlan
 * @date:       2023-10-10
 * @copyright:  Copyright (c) 2022 Stillwater Supercomputing, Inc.
 * @license:    MIT Open Source license 
 * 
 * ***********************************************************************
 */
#pragma once
#include <universal/blas/blas.hpp>

// Condition Number  = 48
sw::universal::blas::matrix<double>  rand8 = {
 {8.909033e-01, 8.142848e-01, 3.516595e-01, 3.804458e-01, 5.688237e-01, 1.656487e-01, 2.289770e-01, 1.066528e-01 },
 {9.592914e-01, 2.435250e-01, 8.308286e-01, 5.678216e-01, 4.693906e-01, 6.019819e-01, 9.133374e-01, 9.618981e-01 },
 {5.472155e-01, 9.292636e-01, 5.852641e-01, 7.585429e-02, 1.190207e-02, 2.629713e-01, 1.523780e-01, 4.634224e-03 },
 {1.386244e-01, 3.499838e-01, 5.497236e-01, 5.395012e-02, 3.371226e-01, 6.540791e-01, 8.258170e-01, 7.749105e-01 },
 {1.492940e-01, 1.965953e-01, 9.171937e-01, 5.307976e-01, 1.621823e-01, 6.892145e-01, 5.383424e-01, 8.173032e-01 },
 {2.575083e-01, 2.510839e-01, 2.858390e-01, 7.791672e-01, 7.942845e-01, 7.481516e-01, 9.961347e-01, 8.686947e-01 },
 {8.407173e-01, 6.160447e-01, 7.572002e-01, 9.340107e-01, 3.112150e-01, 4.505416e-01, 7.817553e-02, 8.443585e-02 },
 {2.542822e-01, 4.732888e-01, 7.537291e-01, 1.299062e-01, 5.285331e-01, 8.382138e-02, 4.426783e-01, 3.997826e-01 },
 };