#pragma once
// sqrt_tables.hpp: specialized posito configurations to support efficient sqrt for small positos
//
// Copyright (C) 2017 Stillwater Supercomputing, Inc.
//
// This file is part of the universal numbers project, which is released under an MIT Open Source license.

namespace sw { namespace universal {

// need a better code generator for the small positos up to nbits = 8
// TODO: find if there is any structure in these tables across nbits and es

template<unsigned nbits, unsigned es>
void GeneratePositoSqrtTable() {
	constexpr unsigned int NR_POSITS = (unsigned(1) << (nbits - 1)); // no need for negative positos

	std::cout << std::setprecision(20);
	posito<nbits, es> p;
	for (unsigned int i = 0; i < NR_POSITS; i++) {
		p.set_raw_bits(i);
		double ref = std::sqrt(double(p));
		posito<nbits, es> psqrt(ref);
		std::cout << p.get() << " " << psqrt.get() << "      " << p << " " << psqrt << " ref: " << ref << std::endl;
	}
	std::cout << std::setprecision(5);
}

// roots for posito<3,0>
//   v   r       v   r          high precision root
//  000 000      0   0     ref : 0
//  001 001      0.5 0.5   ref : 0.70710678118654757274
//	010 010      1   1     ref : 1
//	011 010      2   1     ref : 1.4142135623730951455
constexpr unsigned posito_3_0_roots[4] = { 0, 1, 2, 2 };

// roots for posito<3,1>
//   v   r       v   r          high precision root
//  000 000      0    0     ref : 0
//  001 001      0.25 0.5   ref : 0.5
//	010 010      1   1      ref : 1
//	011 010      4   1      ref : 1
constexpr unsigned posito_3_1_roots[4] = { 0, 1, 2, 2 };

// roots for posito<4,0>
//   v    r        v    r        high precision root
//	0000 0000      0    0        ref: 0
//	0001 0010      0.25 0.5      ref: 0.5
//	0010 0011      0.5  0.75     ref : 0.70710678118654757274
//	0011 0011      0.75 0.75     ref : 0.86602540378443859659
//	0100 0100      1    1        ref : 1
//	0101 0100      1.5  1        ref : 1.2247448713915889407
//	0110 0101      2    1.5      ref : 1.4142135623730951455
//	0111 0110      4    2        ref : 2
constexpr unsigned posito_4_0_roots[8] = { 0, 2, 3, 3, 4, 4, 5, 6 };

// roots for posito<5,0>
//   v     r         v    r        high precision root
//	00000 00000      0     0       ref: 0
//	00001 00011      0.125 0.375   ref : 0.35355339059327378637
//	00010 00100      0.25  0.5     ref : 0.5
//	00011 00101      0.375 0.625   ref : 0.61237243569579447033
//	00100 00110      0.5   0.75    ref : 0.70710678118654757274
//	00101 00110      0.625 0.75    ref : 0.7905694150420948807
//	00110 00111      0.75  0.875   ref : 0.86602540378443859659
//	00111 00111      0.875 0.875   ref : 0.93541434669348533237
//	01000 01000      1     1       ref : 1
//	01001 01000      1.25  1       ref : 1.1180339887498949025
//	01010 01001      1.5   1.25    ref : 1.2247448713915889407
//	01011 01001      1.75  1.25    ref : 1.3228756555322953581
//	01100 01010      2     1.5     ref : 1.4142135623730951455
//	01101 01011      3     1.75    ref : 1.7320508075688771932
//	01110 01100      4     2       ref : 2
//	01111 01101      8     3       ref : 2.8284271247461902909
constexpr unsigned posito_5_0_roots[16] = { 0, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 12, 13 };

// roots of the sqrt for posito<8,0>
constexpr unsigned posito_8_0_roots[128] = {
	0x00, 0x08, 0x0B, 0x0E, 0x10, 0x12, 0x14, 0x15,
	0x17, 0x18, 0x19, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x26,
	0x27, 0x28, 0x29, 0x2A, 0x2A, 0x2B, 0x2C, 0x2D,
	0x2D, 0x2E, 0x2F, 0x2F, 0x30, 0x31, 0x31, 0x32,
	0x33, 0x33, 0x34, 0x34, 0x35, 0x36, 0x36, 0x37,
	0x37, 0x38, 0x39, 0x39, 0x3A, 0x3A, 0x3B, 0x3B,
	0x3C, 0x3C, 0x3D, 0x3D, 0x3E, 0x3E, 0x3F, 0x3F,
	0x40, 0x40, 0x41, 0x41, 0x42, 0x42, 0x43, 0x43,
	0x44, 0x44, 0x45, 0x45, 0x46, 0x46, 0x46, 0x47,
	0x47, 0x48, 0x48, 0x48, 0x49, 0x49, 0x4A, 0x4A,
	0x4A, 0x4B, 0x4B, 0x4B, 0x4C, 0x4C, 0x4D, 0x4D,
	0x4D, 0x4F, 0x50, 0x51, 0x53, 0x54, 0x55, 0x56,
	0x57, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x64, 0x65, 0x66,
	0x67, 0x69, 0x6C, 0x6E, 0x70, 0x72, 0x73, 0x78
};

// roots of the sqrt for posito<8,1>
constexpr unsigned posito_8_1_roots[128] = {
	0x00,0x08,0x0c,0x0e,0x10,0x12,0x13,0x16,
	0x18,0x19,0x1a,0x1b,0x1b,0x1d,0x1e,0x1f,
	0x20,0x21,0x22,0x23,0x24,0x24,0x25,0x26,
	0x27,0x28,0x29,0x2b,0x2c,0x2d,0x2e,0x2f,
	0x30,0x30,0x31,0x31,0x32,0x32,0x33,0x33,
	0x34,0x34,0x34,0x35,0x35,0x36,0x36,0x36,
	0x37,0x37,0x38,0x39,0x39,0x3a,0x3b,0x3b,
	0x3c,0x3c,0x3d,0x3d,0x3e,0x3e,0x3f,0x3f,
	0x40,0x40,0x41,0x41,0x42,0x42,0x43,0x43,
	0x44,0x44,0x44,0x45,0x45,0x46,0x46,0x46,
	0x47,0x47,0x48,0x49,0x49,0x4a,0x4b,0x4b,
	0x4c,0x4c,0x4d,0x4d,0x4e,0x4e,0x4f,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x54,0x55,0x56,
	0x57,0x58,0x59,0x5b,0x5c,0x5d,0x5e,0x5f,
	0x60,0x61,0x62,0x63,0x63,0x65,0x66,0x67,
	0x68,0x6a,0x6b,0x6e,0x70,0x72,0x74,0x78
};

}}  // namespace sw::universal
