#pragma once
// math_functions.hpp: elementary functions for the valid number system
//
// Copyright (C) 2017-2021 Stillwater Supercomputing, Inc.
//
// This file is part of the universal numbers project, which is released under an MIT Open Source license.

/*
https://en.wikipedia.org/wiki/Elementary_function

In mathematics, an elementary function is a function of one variable which is a finite sum, 
product, and/or composition of the rational functions (P(x)/Q(x) for polynomials P and Q), 
sin, cos, exp, and their inverse functions (including arcsin, log, x^(1/n)).

Elementary functions were introduced by Joseph Liouville in a series of papers from 1833 to 1841. 
An algebraic treatment of elementary functions was started by Joseph Fels Ritt in the 1930s.
*/

/*
#include "math/classify.hpp"
#include "math/complex.hpp"
#include "math/constants.hpp"
#include "math/error_and_gamma.hpp"
#include "math/exponent.hpp"
#include "math/fractional.hpp"
#include "math/hyperbolic.hpp"
#include "math/hypot.hpp"
#include "math/logarithm.hpp"
#include "math/minmax.hpp"
#include "math/next.hpp"
#include "math/pow.hpp"
#include "math/sqrt.hpp"
#include "math/trigonometry.hpp"
#include "math/truncate.hpp"
*/
